import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil
import com.liferay.portal.kernel.log.LogFactoryUtil
import com.liferay.portal.model.Layout
import com.liferay.portal.service.LayoutLocalServiceUtil
import com.liferay.portal.service.RoleLocalServiceUtil
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil
import com.liferay.portlet.journal.model.JournalArticle
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil


def log = LogFactoryUtil.getLog("Custom search reindex")

log.info 'start'

def targetGroupIds = [112015, 127828]

def layoutIndexingService = PortletBeanLocatorUtil.locate('em-point-search', 'layoutIndexingService')
def articleIndexingService = PortletBeanLocatorUtil.locate('em-point-search', 'articleIndexingService')
def dlFileEntryIndexingService = PortletBeanLocatorUtil.locate('em-point-search', 'dlFileEntryIndexingService')

def isLatestArticle = { article ->
    try {
        return JournalArticleLocalServiceUtil.isLatestVersion(article.groupId, article.articleId, article.version)
    }   catch ( e ){
        //bad luck...
        return false
    }
}

//reindex
targetGroupIds.each { targetGroupId ->
    //each layout
    [true, false].each { isPrivateLayout ->
        LayoutLocalServiceUtil.getLayouts(targetGroupId, isPrivateLayout).each { layoutIndexingService.index it }
    }

    //each article at the latest version
    JournalArticleLocalServiceUtil.getArticles(targetGroupId).findAll { isLatestArticle it }.each { articleIndexingService.index it }

    //every dlFileEntry
    DLFileEntryLocalServiceUtil.getGroupFileEntries(targetGroupId, -1, -1).each { dlFileEntryIndexingService.index it }

    log.info "groupId ${targetGroupId} done"
}

log.info 'reindexing done'
